/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true, node: true */

(function () {
  "use strict";

  var StringUtils = function () {};

  /**
   * Format a string by replacing placeholder symbols with passed in arguments.
   *
   * Example: var formatted = Strings.formatStr("Hello {0}", "World");
   *
   * @param {string} str The base string
   * @param {...} Arguments to be substituted into the string
   *
   * @return {string} Formatted string
   */
  StringUtils.prototype.formatStr = function (str) {
      // arguments[0] is the base string, so we need to adjust index values here
      if (!str) {
          return "";
      }
      var args = [].slice.call(arguments, 1);
      return str.replace(/\{(\d+)\}/g, function (match, num) {
          return typeof args[num] !== "undefined" ? args[num] : match;
      });
  };

  StringUtils.prototype.escapeBackslashes = function (str) {
    return str.replace(/\\/g, "\\\\");
  };

  StringUtils.prototype.escapeDoubleQuotes = function (str) {
    return str.replace(/"/g, '\\"');
  };

  StringUtils.prototype.escapeSingleQuotes = function (str) {
    return str.replace(/'/g, "\\'");
  };

  StringUtils.prototype.escapeForCodeContext = function (str) {
    // Escaping order is important! First slashes, then everything else.
    str = this.escapeBackslashes(str);

    // Escape both double quotes and single quotes, in case the caller is using one or the other to define this string
    // in a code context.
    str = this.escapeDoubleQuotes(str);
    str = this.escapeSingleQuotes(str);

    return str;
  };

  // If passed value is a string, replace any and all commas with "&#44".
  // It is ok to pass in a value that isn't a string.
  StringUtils.prototype.encodeCommas = function (val) {
    if (typeof(val) === "string") {
        return val.replace(/,/g, "&#44");
    } else {
        return val;
    }
};

  module.exports = new StringUtils();
}());
